<?php

namespace AppBundle\Enum;

/**
 * Warning: be sure that all these constants have a different value
 */
final class ModuleType extends AbstractEnum
{
    /**
     * Module with custom HTML
     */
    const CUSTOM_HTML = 'custom_html';
    
    /**
     * Module displaying last registered users using User Entity
     */
    const LATEST_USERS = 'latest_users';

    /**
     * Module displaying menu children list
     */
    const MENU_CHILDREN_LIST = 'menu_children_list';

    /**
     * Module displaying map with OperationPEE Entity markers
     */
    const MAP_PEE = 'map_pee';

    /**
     * Module displaying some news using Content Entity (with isActu param)
     */
    const NEWS_LIST = 'news_list';

    /**
     * Module displaying Newsletter Form
     */
    const NEWSLETTER = 'newsletter';

    /**
     * Module displaying some partners using Partner Entity
     */
    const PARTNERS_LIST = 'partners_list';

    /**
     * Module displaying some pictures using Media Entity
     */
    const PICTURES_LIST = 'pictures_list';

    /**
     * Module displaying one slider with some slides using Slider Entity
     */
    //const SLIDER = 'slider';

    /**
     * Module displaying one slider with some videos (Youtube)
     */
    const SLIDER_VIDEO = 'slider_video';

    /**
     * Module displaying social networks links
     */
    const SOCIAL = 'social';

    /**
     * Module displaying some testimonials using Testimonial Entity
     */
    const TESTIMONIALS_LIST = 'testimonials_list';

    /**
     * Module displaying some videos using Media Entity
     */
    const VIDEOS_LIST = 'videos_list';
}