<?php

namespace AppBundle\Entity;

use AppBundle\Enum\DemandePEEState;
use AppBundle\Enum\OperationPEEState;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

/**
 * @ORM\Table(name="OperationPEE")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\OperationPeeRepository")
 * @ORM\HasLifecycleCallbacks
 * @Vich\Uploadable
 */
class OperationPEE
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="state", type="string", length=255, nullable=true)
     */
    private $state = OperationPEEState::OPEN;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="date", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateVisite", type="date", nullable=true)
     */
    private $dateVisite;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="startTime", type="time", nullable=true)
     */
    private $startTime;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="endTime", type="time", nullable=true)
     */
    private $endTime;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="publish", type="date", nullable=true)
     */
    private $publish;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="unpublish", type="date", nullable=true)
     */
    private $unpublish;

    /**
     * @var string
     * @deprecated
     *
     * @ORM\Column(name="company", type="string", nullable=true)
     */
    private $companyText;

    /**
     * @var Company
     *
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="peeOperations")
     */
    private $company;

    /**
     * @var Partner
     *
     * @ORM\ManyToOne(targetEntity="Partner", inversedBy="peeOperations")
     */
    private $partner;

    /**
     * @var string
     *
     * @ORM\Column(name="site", type="string", length=255, nullable=true)
     */
    private $site;

    /**
     * @var string
     *
     * @ORM\Column(name="site_image1_path", type="string", length=255, nullable=true)
     */
    private $siteImage1Path;

    /**
     * @var File
     * 
     * @Vich\UploadableField(mapping="operationpee_site_image", fileNameProperty="site_image1_path")
     */
    private $siteImage1File;

    /**
     * @var string
     *
     * @ORM\Column(name="site_image2_path", type="string", length=255, nullable=true)
     */
    private $siteImage2Path;

    /**
     * @var File
     * 
     * @Vich\UploadableField(mapping="operationpee_site_image", fileNameProperty="site_image2_path")
     */
    private $siteImage2File;

    /**
     * @var string
     *
     * @ORM\Column(name="site_image3_path", type="string", length=255, nullable=true)
     */
    private $siteImage3Path;

    /**
     * @var File
     * 
     * @Vich\UploadableField(mapping="operationpee_site_image", fileNameProperty="site_image3_path")
     */
    private $siteImage3File;

    /**
     * @var string
     *
     * @ORM\Column(name="city", type="string", length=255, nullable=true)
     */
    private $city;

    /**
     * @var string
     *
     * @ORM\Column(name="academy", type="string", length=255, nullable=true)
     */
    private $academy;

    /**
     * @var integer
     *
     * @ORM\Column(name="nbPeople", type="integer", nullable=true)
     */
    private $nbPeople;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_active", type="boolean", nullable=true)
     */
    private $is_active = false;

    /**
     * @var string
     *
     * @ORM\Column(name="urlExternalRegistration", type="text", nullable=true)
     */
    private $urlExternalRegistration;

    /**
     * @ORM\OneToMany(targetEntity="DemandePEE", mappedBy="operationpee")
     */
    private $demandepee;

    /**
     * @ORM\ManyToOne(targetEntity="OperationPEECategory", inversedBy="peeOperations", fetch="EXTRA_LAZY")
     */
    private $category;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="text", nullable=true)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="visit", type="text", nullable=true)
     */
    private $visit;

    /**
     * @var string
     *
     * @ORM\Column(name="presentation", type="text", nullable=true)
     */
    private $presentation;

    /**
     * @var string
     *
     * @ORM\Column(name="namely", type="text", nullable=true)
     */
    private $namely;

    /**
     * @var string
     *
     * @ORM\Column(name="audience", type="text", nullable=true)
     */
    private $audience;

    /**
     * @var string
     *
     * @ORM\Column(name="address", type="text", nullable=true)
     */
    private $address;

    /**
     * @var string
     *
     * @ORM\Column(name="zip_code", type="text", nullable=true)
     */
    private $zipCode;

    /**
     * Calculated from the establishment coordinates: address, zipcode and city
     * @var float
     *
     * @ORM\Column(name="latitude", type="float", nullable=true)
     */
    private $latitude = null;

    /**
     * Calculated from the establishment coordinates: address, zipcode and city
     * @var float
     *
     * @ORM\Column(name="longitude", type="float", nullable=true)
     */
    private $longitude = null;

    
    /**
     * in Kilometers. Calculated from user geolocation
     * @var float
     */
    private $distance = null;



    /**
     * @var string
     *
     * @ORM\Column(name="quote_content", type="text", nullable=true)
     */
    private $quoteContent;

    /**
     * @var string
     *
     * @ORM\Column(name="quote_author", type="text", nullable=true)
     */
    private $quoteAuthor;

    /**
     * @var string
     *
     * @ORM\Column(name="quote_author_job", type="text", nullable=true)
     */
    private $quoteAuthorJob;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_new", type="boolean", nullable=false, options={"default": false})
     */
    private $new = false;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_identity_mandatory", type="boolean",  nullable=false, options={"default": false})
     */
    private $is_identity_mandatory = false;

    /**
     * @ORM\Column(name="updated_at", type="datetime", nullable=true)
     *
     * @var \DateTime
     */
    protected $updatedAt;


    /**
     * @var ArrayCollection
     *  
     * @ORM\OneToMany(targetEntity="Interest", mappedBy="operationpee", cascade={"remove","persist"})
     */
    private $interest;


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->demandepee = new ArrayCollection();
        $this->interest = new ArrayCollection();
    }

    /**
     * 
     */
    public function __clone()
    {
        if ($this->id) {
            $this->setId(null);
            $this->setIsActive(false);

            $this->demandepee = new ArrayCollection();
            $this->interest = new ArrayCollection();
        }
    }

    /**
     * Set id
     *
     * @param integer|null $id
     * 
     * @return OperationPEE
     */
    private function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set description
     *
     * @param string $description
     * 
     * @return OperationPEE
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set state
     *
     * @param string $state
     * 
     * @return OperationPEE
     */
    public function setState($state)
    {
        $this->state = $state;

        return $this;
    }

    /**
     * Get state
     *
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * 
     * @return OperationPEE
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->created = new \DateTime();
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set dateVisite
     *
     * @param \DateTime $dateVisite
     * 
     * @return OperationPEE
     */
    public function setDateVisite($dateVisite)
    {
        $this->dateVisite = $dateVisite;

        return $this;
    }

    /**
     * Get dateVisite
     *
     * @return \DateTime
     */
    public function getDateVisite()
    {
        return $this->dateVisite;
    }

    /**
     * Set startTime
     *
     * @param \DateTime $startTime
     * 
     * @return OperationPEE
     */
    public function setStartTime($startTime)
    {
        $this->startTime = $startTime;

        return $this;
    }

    /**
     * Get startTime
     *
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->startTime;
    }

    /**
     * Set endTime
     *
     * @param \DateTime $endTime
     * 
     * @return OperationPEE
     */
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;

        return $this;
    }

    /**
     * Get endTime
     *
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * Set publish
     *
     * @param \DateTime $publish
     * 
     * @return OperationPEE
     */
    public function setPublish($publish)
    {
        $this->publish = $publish;

        return $this;
    }

    /**
     * Get publish
     *
     * @return \DateTime
     */
    public function getPublish()
    {
        return $this->publish;
    }

    /**
     * Set unpublish
     *
     * @param \DateTime $unpublish
     * 
     * @return OperationPEE
     */
    public function setUnpublish($unpublish)
    {
        $this->unpublish = $unpublish;

        return $this;
    }

    /**
     * Get unpublish
     *
     * @return \DateTime
     */
    public function getUnpublish()
    {
        return $this->unpublish;
    }

    /**
     * Set company
     *
     * @param Company $company
     * 
     * @return OperationPEE
     */
    public function setCompany(Company $company)
    {
        $this->company = $company;

        return $this;
    }

    /**
     * Get company
     *
     * @return Company
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set partner
     *
     * @param Partner $partner
     * 
     * @return OperationPEE
     */
    public function setPartner(?Partner $partner = null): OperationPEE
    {
        $this->partner = $partner;

        return $this;
    }

    /**
     * Get partner
     *
     * @return Partner
     */
    public function getPartner()
    {
        return $this->partner;
    }

    /**
     * Set companyText
     * @deprecated
     * @param $companyText
     * @return OperationPEE
     */
    public function setCompanyText($companyText)
    {
        $this->companyText = $companyText;

        return $this;
    }

    /**
     * Get companyText
     * @deprecated
     * @return string
     */
    public function getCompanyText()
    {
        return $this->companyText;
    }

    /**
     * Set site
     *
     * @param string $site
     * 
     * @return OperationPEE
     */
    public function setSite($site)
    {
        $this->site = $site;

        return $this;
    }

    /**
     * Get site
     *
     * @return string
     */
    public function getSite()
    {
        return $this->site;
    }

    /**
     * Set siteImage1File
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile $siteImage1File
     *
     * @return OperationPEE
     */
    public function setSiteImage1File(File $siteImage1File = null)
    {
        $this->siteImage1File = $siteImage1File;

        if ($siteImage1File) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }

        return $this;
    }

    /**
     * Get siteImage1File
     *
     * @return File|null
     */
    public function getSiteImage1File()
    {
        return $this->siteImage1File;
    }

    /**
     * Set siteImage1Path
     *
     * @param string $siteImage1Path
     *
     * @return OperationPEE
     */
    public function setSiteImage1Path($siteImage1Path)
    {
        $this->siteImage1Path = $siteImage1Path;

        return $this;
    }

    /**
     * Get siteImage1Path
     *
     * @return string
     */
    public function getSiteImage1Path()
    {
        return $this->siteImage1Path;
    }

    /**
     * Set siteImage2File
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile $siteImage2File
     *
     * @return OperationPEE
     */
    public function setSiteImage2File(File $siteImage2File = null)
    {
        $this->siteImage2File = $siteImage2File;

        if ($siteImage2File) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }

        return $this;
    }

    /**
     * Get siteImage2File
     *
     * @return File|null
     */
    public function getSiteImage2File()
    {
        return $this->siteImage2File;
    }

    /**
     * Set siteImage2Path
     *
     * @param string $siteImage2Path
     *
     * @return OperationPEE
     */
    public function setSiteImage2Path($siteImage2Path)
    {
        $this->siteImage2Path = $siteImage2Path;

        return $this;
    }

    /**
     * Get siteImage2Path
     *
     * @return string
     */
    public function getSiteImage2Path()
    {
        return $this->siteImage2Path;
    }

    /**
     * Set siteImage3File
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile $siteImage3File
     *
     * @return OperationPEE
     */
    public function setSiteImage3File(File $siteImage3File = null)
    {
        $this->siteImage3File = $siteImage3File;

        if ($siteImage3File) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }

        return $this;
    }

    /**
     * Get siteImage3File
     *
     * @return File|null
     */
    public function getSiteImage3File()
    {
        return $this->siteImage3File;
    }

    /**
     * Set siteImage3Path
     *
     * @param string $siteImage3Path
     *
     * @return OperationPEE
     */
    public function setSiteImage3Path($siteImage3Path)
    {
        $this->siteImage3Path = $siteImage3Path;

        return $this;
    }

    /**
     * Get siteImage3Path
     *
     * @return string
     */
    public function getSiteImage3Path()
    {
        return $this->siteImage3Path;
    }

    /**
     * Set city
     *
     * @param string $city
     * 
     * @return OperationPEE
     */
    public function setCity($city)
    {
        $this->city = $city;

        return $this;
    }

    /**
     * Get city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Set academy
     *
     * @param string $academy
     * 
     * @return OperationPEE
     */
    public function setAcademy($academy)
    {
        $this->academy = $academy;

        return $this;
    }

    /**
     * Get academy
     *
     * @return string
     */
    public function getAcademy()
    {
        return $this->academy;
    }

    /**
     * Set nbPeople
     *
     * @param int $nbPeople
     * 
     * @return OperationPEE
     */
    public function setNbPeople($nbPeople)
    {
        $this->nbPeople = $nbPeople;

        return $this;
    }

    /**
     * Get nbPeople
     *
     * @return integer
     */
    public function getNbPeople()
    {
        return $this->nbPeople;
    }

    /**
     * Set note
     *
     * @param string $note
     * 
     * @return OperationPEE
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * Set urlExternalRegistration
     *
     * @param string $urlExternalRegistration
     * 
     * @return OperationPEE
     */
    public function setUrlExternalRegistration($urlExternalRegistration)
    {
        $this->urlExternalRegistration = $urlExternalRegistration;

        return $this;
    }

    /**
     * Get urlExternalRegistration
     *
     * @return string
     */
    public function getUrlExternalRegistration()
    {
        return $this->urlExternalRegistration;
    }

    /**
     * Set is_active
     *
     * @param bool $isActive
     * 
     * @return OperationPEE
     */
    public function setIsActive($isActive)
    {
        $this->is_active = $isActive;

        return $this;
    }

    /**
     * Get is_active
     *
     * @return boolean
     */
    public function getIsActive()
    {
        return $this->is_active;
    }

    /**
     * Add demandepee
     *
     * @param DemandePEE $demandepee
     * 
     * @return OperationPEE
     */
    public function addDemandepee(DemandePEE $demandepee)
    {
        $this->demandepee[] = $demandepee;

        return $this;
    }

    /**
     * Remove demandepee
     *
     * @param DemandePEE $demandepee
     */
    public function removeDemandepee(DemandePEE $demandepee)
    {
        $this->demandepee->removeElement($demandepee);
    }

    /**
     * Get demandepee
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDemandepee()
    {
        return $this->demandepee;
    }

    /**
     * Set category
     *
     * @param OperationPEECategory $category
     *
     * @return OperationPEE
     */
    public function setCategory(OperationPEECategory $category = null)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * Get category
     *
     * @return OperationPEECategory
     */
    public function getCategory()
    {
        return $this->category;
    }
    
    /**
     * Set title
     *
     * @param string $title
     *
     * @return OperationPEE
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    
    /**
     * Set visit
     *
     * @param string $visit
     *
     * @return OperationPEE
     */
    public function setVisit($visit)
    {
        $this->visit = $visit;

        return $this;
    }

    /**
     * Get visit
     *
     * @return string
     */
    public function getVisit()
    {
        return $this->visit;
    }
    
    /**
     * Set presentation
     *
     * @param string $presentation
     *
     * @return OperationPEE
     */
    public function setPresentation($presentation)
    {
        $this->presentation = $presentation;

        return $this;
    }

    /**
     * Get presentation
     *
     * @return string
     */
    public function getPresentation()
    {
        return $this->presentation;
    }
    
    /**
     * Set namely
     *
     * @param string $namely
     *
     * @return OperationPEE
     */
    public function setNamely($namely)
    {
        $this->namely = $namely;

        return $this;
    }

    /**
     * Get namely
     *
     * @return string
     */
    public function getNamely()
    {
        return $this->namely;
    }
    
    /**
     * Set audience
     *
     * @param string $audience
     *
     * @return OperationPEE
     */
    public function setAudience($audience)
    {
        $this->audience = $audience;

        return $this;
    }

    /**
     * Get audience
     *
     * @return string
     */
    public function getAudience()
    {
        return $this->audience;
    }

    /**
     * Set address
     *
     * @param string $address
     *
     * @return OperationPEE
     */
    public function setAddress($address)
    {
        $this->address = $address;

        return $this;
    }

    /**
     * Get address
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Set zipCode
     *
     * @param string $zipCode
     *
     * @return OperationPEE
     */
    public function setZipcode($zipCode)
    {
        $this->zipCode = $zipCode;

        return $this;
    }

    /**
     * Get zipCode
     *
     * @return string
     */
    public function getZipcode()
    {
        return $this->zipCode;
    }

    /**
     * Set latitude
     *
     * @param float $latitude
     *
     * @return OperationPEE
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;

        return $this;
    }

    /**
     * Get latitude
     *
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Set longitude
     *
     * @param float $longitude
     *
     * @return OperationPEE
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;

        return $this;
    }

    /**
     * Get longitude
     *
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Set distance
     *
     * @param float $distance
     *
     * @return OperationPEE
     */
    public function setDistance($distance)
    {
        $this->distance = $distance;

        return $this;
    }

    /**
     * Get distance
     *
     * @return float
     */
    public function getDistance()
    {
        return $this->distance;
    }

    /**
     * Set quoteContent
     *
     * @param string $quoteContent
     *
     * @return OperationPEE
     */
    public function setQuoteContent($quoteContent)
    {
        $this->quoteContent = $quoteContent;

        return $this;
    }

    /**
     * Get quoteContent
     *
     * @return string
     */
    public function getQuoteContent()
    {
        return $this->quoteContent;
    }

    /**
     * Set quote author
     *
     * @param string $quoteAuthor
     *
     * @return OperationPEE
     */
    public function setQuoteAuthor(?string $quoteAuthor = null)
    {
        $this->quoteAuthor = $quoteAuthor;

        return $this;
    }

    /**
     * Get quote author
     *
     * @return string
     */
    public function getQuoteAuthor(): ?string
    {
        return $this->quoteAuthor;
    }

    /**
     * Set quote author job
     *
     * @param string $quoteAuthorJob
     *
     * @return OperationPEE
     */
    public function setQuoteAuthorJob(?string $quoteAuthorJob = null)
    {
        $this->quoteAuthorJob = $quoteAuthorJob;

        return $this;
    }

    /**
     * Get quote author job
     *
     * @return string
     */
    public function getQuoteAuthorJob(): ?string
    {
        return $this->quoteAuthorJob;
    }

    /**
     * Set new
     *
     * @param string $new
     * 
     * @return OperationPEE
     */
    public function setNew($new): OperationPEE
    {
        $this->new = $new;

        return $this;
    }

    /**
     * Get new
     * 
     * @return bool     
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     *
     * @return OperationPEE
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Get the readable filename of the printable version of the operation.
     * Examples:
     * - Visit date is set: 2017.08.15 - Airbus Toulouse.pdf
     * - Visit date not set: 2017 - Airbus Toulouse.pdf
     * @param bool     $withExtension
     * @return string 
     */
    public function getPdfReadableName(bool $withExtension = true): string
    {
        $date = $this->getDateVisite() ?? new \DateTime();

        return join(' - ', [
            $this->getDateVisite() ? $date->format('Y.m.d') : $date->format('Y'),
            $this->getCompany(),
            $this->getSite(),
        ]) . ($withExtension ? '.pdf' : '');
    }

    /**
     * Indicate if the operation if full,
     * according to the state (registered and preregistered)
     * of the related applications.
     * @return boolean 
     */
    public function isFull(): bool
    {
        $applications = $this->getDemandepee()->filter(function(DemandePEE $application) {
            return DemandePEEState::REGISTERED === $application->getState()
                || DemandePEEState::PREREGISTERED === $application->getState()
            ;
        });

        return $this->getNbPeople() - count($applications) <= 0;
    }

    /**
     * Add interest
     *
     * @param Interest $interest
     * @return OperationPEE
     */
    public function addInterest(Interest $interest)
    {
        $this->interest[] = $interest;
        $interest->setOperationpee($this);

        return $this;
    }

    /**
     * Remove interest
     *
     * @param Interest $interest
     */
    public function removeInterest(Interest $interest)
    {
        $this->interest->removeElement($interest);
    }

    /**
     * Get interest
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getInterest()
    {
        return $this->interest;
    }

    /**
     * Set is identity mandatory
     *
     * @param bool $isMandatory
     *
     * @return OperationPEE
     */
    public function setIsIdentityMandatory($isMandatory)
    {
        $this->is_identity_mandatory = $isMandatory;

        return $this;
    }

    /**
     * Get is identity mandatory
     *
     * @return boolean
     */
    public function getIsIdentityMandatory()
    {
        return $this->is_identity_mandatory;
    }
}
