<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="DemandePEE")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\DemandePeeRepository")
 * @ORM\HasLifecycleCallbacks
 * @ORM\EntityListeners({"AppBundle\EventListener\Doctrine\DemandePEEListener"})
 */
class DemandePEE
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="state", type="string", length=255, nullable=true)
     */
    private $state;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=255, nullable=true)
     */
    private $type = null;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="date", nullable=true)
     */
    private $created;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_active", type="boolean", nullable=true)
     */
    private $is_active = true;

    /**
     * @var OperationPEE
     *
     * @ORM\ManyToOne(targetEntity="OperationPEE", inversedBy="demandepee")
     * @ORM\JoinColumn(name="operationpee", referencedColumnName="id", nullable=false, onDelete="CASCADE")
     */
    private $operationpee;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\User", inversedBy="demandepee")
     * @ORM\JoinColumn(name="cuser", referencedColumnName="id", nullable=false)
     */
    private $cuser;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set state
     *
     * @param string $state
     * 
     * @return DemandePEE
     */
    public function setState($state)
    {
        $this->state = $state;

        return $this;
    }

    /**
     * Get state
     *
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Set type
     *
     * @param string $type
     * 
     * @return DemandePEE
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->created = new \DateTime();
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * 
     * @return DemandePEE
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set operationpee
     *
     * @param OperationPEE $operationpee
     * 
     * @return DemandePEE
     */
    public function setOperationpee(OperationPEE $operationpee)
    {
        $this->operationpee = $operationpee;

        return $this;
    }

    /**
     * Get operationpee
     *
     * @return OperationPEE
     */
    public function getOperationpee()
    {
        return $this->operationpee;
    }

    /**
     * Set cuser
     *
     * @param User $cuser
     * 
     * @return DemandePEE
     */
    public function setCuser(User $cuser)
    {
        $this->cuser = $cuser;

        return $this;
    }

    /**
     * Get cuser
     *
     * @return User
     */
    public function getCuser()
    {
        return $this->cuser;
    }

    /**
     * Set is_active
     *
     * @param bool $isActive
     * 
     * @return DemandePEE
     */
    public function setIsActive($isActive)
    {
        $this->is_active = $isActive;

        return $this;
    }

    /**
     * Get is_active
     *
     * @return boolean
     */
    public function getIsActive()
    {
        return $this->is_active;
    }

    /**
     * Set note
     *
     * @param string $note
     * 
     * @return DemandePEE
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }
}
