<?php

namespace AppBundle\Entity;

use AppBundle\Entity\OperationPEECategory;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Company
 * @author Bastien Gatellier <contact@bgatellier.fr>
 *
 * @ORM\Entity(repositoryClass="AppBundle\Repository\CompanyRepository")
 */
class Company extends Establishment
{
    /**
     * @var boolean $availableForUsers
     *
     * @ORM\Column(name="available_for_users", type="boolean", options={"default": false})
     */
    protected $availableForUsers = false;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="OperationPEE", mappedBy="company", fetch="EXTRA_LAZY")
     */
    private $peeOperations;

    /**
     * @var boolean $selectableInPEE
     *
     * @ORM\Column(name="selectable_in_pee", type="boolean", options={"default": true})
     */
    protected $selectableInPEE = true;


    /**
     * @var ArrayCollection
     * @ORM\ManyToOne(targetEntity="OperationPEECategory", inversedBy="compagnies", fetch="EXTRA_LAZY")
     */
    private $companyCategory;


    public function __construct()
    {
        parent::__construct();
    }
    

    /**
     * Set availableForUsers
     *
     * @param bool $availableForUsers
     *
     * @return Company
     */
    public function setAvailableForUsers($availableForUsers)
    {
        $this->availableForUsers = $availableForUsers;

        return $this;
    }

    /**
     * Get availableForUsers
     *
     * @return bool
     */
    public function isAvailableForUsers()
    {
        return $this->availableForUsers;
    }

    /**
     * Add OperationPEE
     *
     * @param OperationPEE $peeOperation
     * 
     * @return Company
     */
    public function addPeeOperation(OperationPEE $peeOperation)
    {
        $this->peeOperations[] = $peeOperation;

        return $this;
    }

    /**
     * Remove peeOperation
     *
     * @param OperationPEE $peeOperation
     */
    public function removePeeOperation(OperationPEE $peeOperation)
    {
        $this->peeOperations->removeElement($peeOperation);
    }

    /**
     * Get peeOperations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPeeOperations()
    {
        return $this->peeOperations;
    }

    /**
     * Set category
     *
     * @param OperationPEECategory $category
     *
     * @return Company
     */
    public function setCompanyCategory($category)
    {
        $this->companyCategory = $category;

        return $this;
    }

    /**
     * Get category
     *
     * @return OperationPEECategory
     */
    public function getCompanyCategory()
    {
        return $this->companyCategory;
    }

    /**
     * Set category
     *
     * @param OperationPEECategory $category
     *
     * @return Company
     */
    public function setCategory($category)
    {
        return $this->setCompanyCategory($category);
    }

    /**
     * Get category
     *
     * @return OperationPEECategory
     */
    public function getCategory()
    {
        return $this->getCompanyCategory();
    }

    /**
     * Set if partner is displaying in PEE Partner select field
     *
     * @param bool $selectableInPEE
     *
     * @return Company
     */
    public function setSelectableInPEE($selectableInPEE)
    {
        $this->selectableInPEE = $selectableInPEE;

        return $this;
    }

    /**
     * Get if partner is displaying in PEE Partner select field
     *
     * @return bool
     */
    public function getSelectableInPEE()
    {
        return $this->selectableInPEE;
    }

    /**
     * Indicates if a company can be deleted.
     * @return boolean 
     */
    public function isDeletable()
    {
        return
            0 === $this->getUsers()->count()
            && 0 === $this->getPeeOperations()->count()
        ;
    }
}
