#!/usr/bin/env bash
# This file is set up for running in a Symfony PROD environment

# Turn on the maintenance mode
php bin/console lexik:maintenance:lock --no-interaction

# If export.zip exists
if [[ -f "export.zip" ]]; then
    # Please save the files that will change with update
    DATE=`date '+%Y%m%d%H%M%S'`
    zip -r ${DATE}-backup.zip deploy.sh composer.json package.json app/config/security.yml app/config/services.yml app/config/routing.yml app/config/parameters.yml.dist app/config/bundles/ app/config/config.yml app/DoctrineMigrations app/Resources/assets app/Resources/FOSUserBundle app/Resources/translations app/Resources/views assets src/AppBundle/ web/admin web/front  

    # Delete folders affected by a restructuring
    rm -rf composer.json package.json app/config/security.yml app/config/services.yml app/config/routing.yml app/config/parameters.yml.dist app/config/bundles/ app/config/config.yml app/DoctrineMigrations app/Resources/assets app/Resources/FOSUserBundle app/Resources/translations app/Resources/views assets src/AppBundle/ web/admin web/front

    # Updates files
    yes | unzip export.zip

    # Delete update zip
    rm -f export.zip
fi

# Reload config file before doctrine migration 
php bin/console cache:clear

# Create the database
php bin/console doctrine:database:create --if-not-exists

# Execute database migrations
php bin/console doctrine:migrations:migrate --no-interaction

# Install the application
php composer.phar install --no-dev -o -v

# Make executable the HTML to PDF converter
chmod +x app/Resources/wkhtmltopdf/wkhtmltopdf

# Turn off the maintenance mode
php bin/console lexik:maintenance:unlock --no-interaction